<?php
session_start();
include 'constants.php';
include 'portal_admin.php';

try{
  $portal = new PortalAdmin("localhost", "php", "test", "testphp");
}
catch(Exception $e){
  //echo 'Problem z bazą danych. ' . $e->getMessage();
  exit('Panel administracyjny jest niedostępny.');
}

//Sprawdzenie czy jest parametr action
if (isset($_GET['action'])) {
  $action = $_GET['action'];
}
else{
  $action = 'showMainAdmin';
}

//Odczytanie komunikatu, jeśli został przekazany
$komunikat_adm = $portal->getAdminMessage();

//Wykonanie procedury logowania lub wylogowania
switch($action){
  case 'login':
    if(!$portal->zalogowany_adm)
    switch($portal->login()){
      case LOGIN_OK:
        $portal->setAdminMessage("Zalogowanie prawidłowe");
        break;
      case LOGIN_FAILED:
        $portal->setAdminMessage("Nieprawidłowa nazwa lub hasło!");
        break;
      case NO_ADMIN_RIGHTS:
        $portal->setAdminMessage("Brak uprawnień administracyjnych!");
        $portal->logout();
        break;
      case SERVER_ERROR:
      default:
        $portal->setAdminMessage("Błąd serwera!");
        $portal->logout();
    }
    header('Location:index.php');
    exit();
  case 'logout':
    $portal->logout();
    header('Location:index.php');
    exit();
}

//Ustalenie akcji dla niezalogowanego użytkownika
if(!$portal->zalogowany_adm){
  $action = 'showLoginForm';
}
include 'templates/mainTemplate.php';
?>